#include <stdio.h>
#include <assert.h>
#include <math.h>
#include <stddef.h>
#include <stdlib.h>
//#include <sstream>
#include <string>

#include "AutoGranny.h"
//#include "GR2Format.h"

#include "Granny.h"
#pragma warning(disable:4996) // deprecated functions

#include "b64.h"

typedef float	granny_real32;

#define M_PI	3.14159265358979323846

int NumberOfFrames = -1;
granny_real32 AnimationDuration;

//GrannyStack stack;

int Indentation = 0;

void Indent(FILE* f)
{
	for (int i = 0; i < Indentation; i++)
	{
		fprintf(f, " ");
	}
}

t_FileInfo* TMPModelInfo;

int FindIndexInList(int Count, int** List, int* Item)
{
	for (int i = 0; i < Count; i++)
	{
		if (List[i] == Item)
		{
			return i;
		}
	}
	return -1;
}

void __cdecl log(int a, int b, char* msg)
{
	printf("-- Log (%d %d) %s\n", a, b, msg);
}

GrannyLogger logger = { &log, &log };

//These defines allow you to control what data you want to output:
#define OutputArtToolData
#define OutputExporterData
#define OutputModelData
#define OutputMeshData
#define OutputSkeletonData
#define OutputBoneData
#define OutputMaterialData
#define OutputTextureData
#define OutputPixelData
//#define OutputMIPData
#define OutputAnimationData
#define OutputTrackGroupData
//#define OutputDetailTrackGroupData

int TicksPerFrame = 1; // GetTicksPerFrame()
float FramesPerSecond = 60.0;

float TimeToFrame(float time)
	{
		return time * FramesPerSecond * TicksPerFrame;
	}
float FrameToTime(float time)
	{
		return float(time) / (FramesPerSecond * TicksPerFrame);
	}

void OutputExtendedData(FILE* f, t_ExtendedData* ExtendedData)
	{
		if (ExtendedData == NULL)
			return;
		return; //FIXME: NOT WORKING!
		for (int i = 0; i < ExtendedData->Properties_count; i++)
			{
				Indent(f);
				fprintf(f, "extended data(\n");
				Indentation += 2;
				Indent(f);
				fprintf(f, "extended data name: %s\n", ExtendedData->Properties[i].Name);
				Indent(f);
				fprintf(f, "extended data type: %d\n", ExtendedData->Properties[i].Type);
				//FIXME: MISSING STUFF HERE!
				Indent(f);
				fprintf(f, "extended data len: %d\n", ExtendedData->Properties[i].Len);
				Indent(f);
				fprintf(f, "extended data unk2: %d\n", ExtendedData->Properties[i].Unk2);
				Indent(f);
				fprintf(f, "extended data unk3: %d\n", ExtendedData->Properties[i].Unk3);
				Indent(f);
				fprintf(f, "extended data unk4: %d\n", ExtendedData->Properties[i].Unk4);
				Indent(f);
				fprintf(f, "extended data unk5: %d\n", ExtendedData->Properties[i].Unk5);
				Indentation -= 2;
				Indent(f);
				fprintf(f, ")\n");
			}
	}

#ifdef OutputMaterialData
	void OutputMaterialBinding(FILE* f, t_MaterialBindings MaterialBindings)
	{
		Indent(f);
		fprintf(f, "materialbinding (\n");
		Indentation += 2;
		int i = FindIndexInList(TMPModelInfo->Materials_count, reinterpret_cast<int**>(TMPModelInfo->Materials), reinterpret_cast<int*>(MaterialBindings.Material));
		Indent(f);
		fprintf(f, "materialbinding material: %d\n", i);
		Indentation -= 2;
		Indent(f);
		fprintf(f, ")\n");
	}
#endif

#ifdef OutputBoneData
	void OutputBoneBinding(FILE* f, t_BoneBindings BoneBinding)
	{
		Indent(f);
		fprintf(f, "bonebinding (\n");
		Indentation += 2;
		Indent(f);
		fprintf(f, "bonebinding bonename: %s\n", BoneBinding.BoneName);
		Indent(f);
		fprintf(f, "bonebinding OBBMin: [%f,%f,%f]\n", BoneBinding.OBBMin[0], BoneBinding.OBBMin[1], BoneBinding.OBBMin[2]);
		Indent(f);
		fprintf(f, "bonebinding OBBMax: [%f,%f,%f]\n", BoneBinding.OBBMax[0], BoneBinding.OBBMax[1], BoneBinding.OBBMax[2]);
		for (int j = 0; j < BoneBinding.TriangleIndices_count; ++j)
		{
			Indent(f);
			fprintf(f, "bonebinding triangle index: %d\n", BoneBinding.TriangleIndices[j]);
		}
		Indentation -= 2;
		Indent(f);
		fprintf(f, ")\n");
	}
#endif

#ifdef OutputMeshData
	void OutputTriTopology(FILE* f, t_TriTopologies* TriTopologyBinding)
	{
		Indent(f);
		fprintf(f, "tritopology (\n");
		Indentation += 2;

		for (int i = 0; i < TriTopologyBinding->Groups_count; i++)
		{
			Indent(f);
			fprintf(f, "group (\n");
			Indentation += 2;

			Indent(f);
			fprintf(f, "group materialindex: %d\n", TriTopologyBinding->Groups[i].MaterialIndex);
			Indent(f);
			fprintf(f, "group trifirst: %d\n", TriTopologyBinding->Groups[i].TriFirst);
			Indent(f);
			fprintf(f, "group tricount: %d\n", TriTopologyBinding->Groups[i].TriCount);

			Indentation -= 2;
			Indent(f);
			fprintf(f, ")\n");
		}

		for (int i = 0; i < TriTopologyBinding->Indices_count/3; i++)
		{
			Indent(f);
			fprintf(f, "face (\n");
			Indentation += 2;

			Indent(f);
			fprintf(f, "face indices: [%d,%d,%d]\n",
				TriTopologyBinding->Indices[i*3+0].Int32,
				TriTopologyBinding->Indices[i*3+1].Int32,
				TriTopologyBinding->Indices[i*3+2].Int32);

			Indentation -= 2;
			Indent(f);
			fprintf(f, ")\n");
		}

		for (int i = 0; i < TriTopologyBinding->Indices16_count/3; i++)
		{
			Indent(f);
			fprintf(f, "face (\n");
			Indentation += 2;

			Indent(f);
			fprintf(f, "face indices: [%d,%d,%d]\n",
				TriTopologyBinding->Indices16[i*3+0].Int16,
				TriTopologyBinding->Indices16[i*3+1].Int16,
				TriTopologyBinding->Indices16[i*3+2].Int16);

			Indentation -= 2;
			Indent(f);
			fprintf(f, ")\n");
		}

		Indentation -= 2;
		Indent(f);
		fprintf(f, ")\n");
	}
#endif

#ifdef OutputMeshData
	void OutputMesh(FILE* f, t_Meshes* mesh, int nverts = -1, int nindices = -1)
		{
			Indent(f);
			fprintf(f, "mesh (\n");
			Indentation += 2;

			if (nverts == -1)
				nverts = (*GrannyGetMeshVertexCount)(mesh);
			if (nindices == -1)
				nindices = (*GrannyGetMeshIndexCount)(mesh);

			Indent(f);
			fprintf(f, "mesh name: %s\n", mesh->Name);

			t_Vertex_PWNT3432* verts = new t_Vertex_PWNT3432[nverts];
			(*GrannyCopyMeshVertices)(mesh, GrannyPWNT3432VertexType, verts);

			for (int i = 0; i < nverts; ++i)
			{
				Indent(f);
				fprintf(f, "vert (\n");
				Indentation += 2;

				Indent(f);
				fprintf(f, "vert number: %d\n",
					 i);
				Indent(f);
				fprintf(f, "vert position: [%f,%f,%f]\n",
					verts[i].Position[0], verts[i].Position[1], verts[i].Position[2]);
				Indent(f);
				fprintf(f, "vert texture coords: [%f,%f,%f]\n",
					verts[i].TextureCoordinates0[0], verts[i].TextureCoordinates0[1], 0.0f);
				Indent(f);
				fprintf(f, "vert normal: [%f,%f,%f]\n",
					verts[i].Normal[0], verts[i].Normal[1], verts[i].Normal[2]);
				Indent(f);
				fprintf(f, "vert bone indices: [%d,%d,%d,%d]\n",
					verts[i].BoneIndices[0], verts[i].BoneIndices[1], verts[i].BoneIndices[2], verts[i].BoneIndices[3]);
				Indent(f);
				fprintf(f, "vert bone weights: [%d,%d,%d,%d]\n",
					verts[i].BoneWeights[0], verts[i].BoneWeights[1], verts[i].BoneWeights[2], verts[i].BoneWeights[3]);

				Indentation -= 2;
				Indent(f);
				fprintf(f, ")\n");
			}
			delete[] verts;

			if (mesh->PrimaryTopology != NULL)
			{
				int j = FindIndexInList(TMPModelInfo->TriTopologies_count, reinterpret_cast<int**>(TMPModelInfo->TriTopologies), reinterpret_cast<int*>(mesh->PrimaryTopology));
				Indent(f);
				fprintf(f, "mesh primarytopologybinding: %d\n", j);
			}

			#ifdef OutputMaterialData
				for (int i = 0; i < mesh->MaterialBindings_count ; ++i)
				{
					OutputMaterialBinding(f, mesh->MaterialBindings[i]);
				}
			#endif

			// Prints to .ms output file the bone name, frame min and max bounding box coords, ex:
			// bonebinding (
			//   name: Bip_Masha L Hand
			//   OBBMin: [-8.174599,-5.880524,-23.018808]
			//   OBBMax: [39.566097,8.321136,15.006678]
			// )
			#ifdef OutputBoneData
				for (int i = 0; i < mesh->BoneBindings_count; ++i)
				{
					OutputBoneBinding(f, mesh->BoneBindings[i]);
				}
			#endif

			Indentation -= 2;
			Indent(f);
			fprintf(f, ")\n\n");
		}
#endif

#ifdef OutputTextureData
	void OutputMap(FILE* f, t_Maps Map)
		{
			Indent(f);
			fprintf(f, "map (\n");
			Indentation += 2;
			Indent(f);
			fprintf(f, "map usage: %s\n", Map.Usage);
			#ifdef OutputMaterialData
				int i = FindIndexInList(TMPModelInfo->Materials_count, reinterpret_cast<int**>(TMPModelInfo->Materials), reinterpret_cast<int*>(Map.Map));
				Indent(f);
				fprintf(f, "map material: %d\n", i);
			#endif
			Indentation -= 2;
			Indent(f);
			fprintf(f, ")\n");
		}
#endif

#ifdef OutputMIPData
	void OutputMIPLevel(FILE* f, t_MIPLevels MIPLevel)
		{
			Indent(f);
			fprintf(f, "miplevel (\n");
			Indentation += 2;
			Indent(f);
			fprintf(f, "stride: %d\n", MIPLevel.Stride);
			Indent(f);
			fprintf(f, "pixel_count: %d\n", MIPLevel.Pixels_count);
			Indent(f);
			fprintf(f, "pixel: ");
			t_Pixels* Current_Pixel = MIPLevel.Pixels;
			for (int i = 0; i < MIPLevel.Pixels_count; i++)
				{
					if (i != 0)
						fprintf(f, ",");
					fprintf(f, "%d", Current_Pixel->UInt8);
					Current_Pixel += sizeof(t_Pixels);
				}
			fprintf(f, "\n");
			Indentation -= 2;
			Indent(f);
			fprintf(f, ")\n");
		}
#endif

#ifdef OutputMIPData
	void OutputImage(FILE* f, t_Images Image)
		{
			for (int i = 0; i < Image.MIPLevels_count; i++)
				{
					OutputMIPLevel(f, Image.MIPLevels[i]);
				}
		}
#endif

#ifdef OutputTextureData
	void OutputTexture(FILE* f, t_Texture* Texture)
		{
			if (Texture == NULL)
				return;
			Indent(f);
			fprintf(f, "texture (\n");
			Indentation += 2;
			Indent(f);
			fprintf(f, "fromfilename: %s\n", Texture->FromFileName);
			Indent(f);
			fprintf(f, "texturetype: %d\n", Texture->TextureType);
			Indent(f);
			fprintf(f, "width: %d\n", Texture->Width);
			Indent(f);
			fprintf(f, "height: %d\n", Texture->Height);
			Indent(f);
			fprintf(f, "encoding: %d\n", Texture->Encoding);
			Indent(f);
			fprintf(f, "subformat: %d\n", Texture->SubFormat);
			Indent(f);
			fprintf(f, "BytesPerPixel: %d\n", Texture->Layout.BytesPerPixel);
			Indent(f);
			fprintf(f, "ShiftForComponent: [%d,%d,%d,%d]\n", Texture->Layout.ShiftForComponent[0], Texture->Layout.ShiftForComponent[1], Texture->Layout.ShiftForComponent[2], Texture->Layout.ShiftForComponent[3]);
			Indent(f);
			fprintf(f, "BitsForComponent: [%d,%d,%d,%d]\n", Texture->Layout.BitsForComponent[0], Texture->Layout.BitsForComponent[1], Texture->Layout.BitsForComponent[2], Texture->Layout.BitsForComponent[3]);

			#ifdef OutputPixelData
				/* This is probably what most people want:
				granny_pixel_layout *Layout = (granny_pixel_layout*)GrannyRGB888PixelFormat;
				granny_int32x Stride = Texture->Width * Layout->BytesPerPixel;

				This is what QuArK wants:
				*/
				granny_pixel_layout *Layout = (granny_pixel_layout*)GrannyBGR888PixelFormat;
				granny_int32x Padding = (int(((Texture->Width * 8) + 31) / 32) * 4) - (Texture->Width * 1); //QuArK's padding
				granny_int32x Stride = Texture->Width * Layout->BytesPerPixel + Padding;
				granny_int32 Size = (*GrannyGetRawImageSize)(Layout, Stride, Texture->Width, Texture->Height);
				void * PixelBuffer = malloc(Size);
				if (PixelBuffer == 0)
				{
					//FIXME: Something went wrong...!
				}
				(*GrannyCopyTextureImage)(Texture, 0, 0, Layout, Texture->Width, Texture->Height, Stride, PixelBuffer);
				//Flip it
				void * PixelBuffer2 = malloc(Size);
				if (PixelBuffer2 == 0)
				{
					//FIXME: Something went wrong...!
				}
				void * PixelBufferTMP;
				void * PixelBuffer2TMP;
				for (int i = 0; i < Texture->Height; i++)
				{
					PixelBufferTMP = ((char*)PixelBuffer) + (i * Stride);
					PixelBuffer2TMP = ((char*)PixelBuffer2) + ((Texture->Height - i - 1) * Stride);
					memcpy(PixelBuffer2TMP, PixelBufferTMP, Stride);
				}
				free(PixelBuffer);
				std::string OutBuffer = encode((char*)PixelBuffer2, Size);
				free(PixelBuffer2);
				Indent(f);
				fprintf(f, "imagedata: ");
				fwrite(OutBuffer.c_str(), OutBuffer.length(), 1, f);
				fprintf(f, "\n");

				/*for (int i = 0; i < Texture->Images_count; i++)
				{
					OutputImage(f, Texture->Images[i]);
				}*/
			#endif
			OutputExtendedData(f, Texture->ExtendedData);
			Indentation -= 2;
			Indent(f);
			fprintf(f, ")\n");
		}
#endif

#ifdef OutputMaterialData
	void OutputMaterial(FILE* f, t_Materials* Material)
	{
		if (Material == NULL)
			return;
		Indent(f);
		fprintf(f, "material (\n");
		Indentation += 2;
		Indent(f);
		fprintf(f, "material name: %s\n", Material->Name);
		#ifdef OutputTextureData
			for (int i = 0; i < Material->Maps_count; i++)
			{
				OutputMap(f, Material->Maps[i]);
			}
			OutputTexture(f, Material->Texture);
		#endif
		OutputExtendedData(f, Material->ExtendedData);
		Indentation -= 2;
		Indent(f);
		fprintf(f, ")\n");
	}
#endif

#ifdef OutputBoneData
	void OutputBone(FILE* f, t_Bones Bone)
	{
		Indent(f);
		fprintf(f, "bone (\n");
		Indentation += 2;
		Indent(f);
		fprintf(f, "bone name: %s\n", Bone.Name);
		Indent(f);
		fprintf(f, "bone parentindex: %d\n", Bone.ParentIndex);
		Indent(f);
 	    fprintf(f, "bone transform dimensions: %d\n", Bone.Transform.Dimensions);
		Indent(f);
		fprintf(f, "bone transform origin: [%f,%f,%f]\n",
			Bone.Transform.Origin.Point[0],
			Bone.Transform.Origin.Point[1],
			Bone.Transform.Origin.Point[2]);
		Indent(f);
		fprintf(f, "bone transform rotation: [%f,%f,%f,%f]\n",
			Bone.Transform.Rotation.Point[0],
			Bone.Transform.Rotation.Point[1],
			Bone.Transform.Rotation.Point[2],
			Bone.Transform.Rotation.Point[3]);
		Indent(f);
		fprintf(f, "bone transform scale: [%f,%f,%f,%f,%f,%f,%f,%f,%f]\n",
			Bone.Transform.Scale[0],
			Bone.Transform.Scale[1],
			Bone.Transform.Scale[2],
			Bone.Transform.Scale[3],
			Bone.Transform.Scale[4],
			Bone.Transform.Scale[5],
			Bone.Transform.Scale[6],
			Bone.Transform.Scale[7],
			Bone.Transform.Scale[8]);
		Indent(f);
		fprintf(f, "bone InverseWorldTransform: [%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f]\n",
			Bone.InverseWorldTransform[0],
			Bone.InverseWorldTransform[1],
			Bone.InverseWorldTransform[2],
			Bone.InverseWorldTransform[3],
			Bone.InverseWorldTransform[4],
			Bone.InverseWorldTransform[5],
			Bone.InverseWorldTransform[6],
			Bone.InverseWorldTransform[7],
			Bone.InverseWorldTransform[8],
			Bone.InverseWorldTransform[9],
			Bone.InverseWorldTransform[10],
			Bone.InverseWorldTransform[11],
			Bone.InverseWorldTransform[12],
			Bone.InverseWorldTransform[13],
			Bone.InverseWorldTransform[14],
			Bone.InverseWorldTransform[15]);
		Indent(f);
		fprintf(f, "bone LODError: %f\n", Bone.LODError);
		OutputExtendedData(f, Bone.ExtendedData);
		Indentation -= 2;
		Indent(f);
		fprintf(f, ")\n");
	}
#endif

#ifdef OutputSkeletonData
	void OutputSkeleton(FILE* f, t_Skeletons* Skeleton)
	{
		if (Skeleton == NULL)
			return;
		Indent(f);
		fprintf(f, "skeleton (\n");
		Indentation += 2;
		Indent(f);
		fprintf(f, "skeleton name: %s\n", Skeleton->Name);
		Indent(f);
		fprintf(f, "skeleton LOD type: %d\n", Skeleton->LODType);
		#ifdef OutputBoneData
			for (int i = 0; i < Skeleton->Bones_count; i++)
			{
				OutputBone(f, Skeleton->Bones[i]);
			}
		#endif
		OutputExtendedData(f, Skeleton->ExtendedData);
		Indentation -= 2;
		Indent(f);
		fprintf(f, ")\n\n");
	}
#endif

	void OutputCurve(FILE* f, void* xCurveDataHeader)
	{
		//Note: NO INDENTATION CHANGES NEEDED HERE!
		t_CurveDataHeader* CurveDataHeader = (t_CurveDataHeader*) xCurveDataHeader;
		Indent(f);
		fprintf(f, "curve format: %d\n", CurveDataHeader->Format);
		Indent(f);
		fprintf(f, "curve degree: %d\n", CurveDataHeader->Degree);
		granny_curve2 GrCurve2;
		GrCurve2.CurveData.Object = xCurveDataHeader;
		GrCurve2.CurveData.Type = (granny_data_type_definition*) GrannyCurve2Type;
		granny_int32x ControlDimension = (*GrannyCurveGetDimension)(&GrCurve2);
		Indent(f);
		fprintf(f, "curve dimension: %d\n", ControlDimension);
		if (ControlDimension != 0)
		{
			granny_real32 *IdentityVector = new granny_real32[ControlDimension];
			switch (ControlDimension)
			{
				case 3:
				{
					IdentityVector[0] = 0.0f;
					IdentityVector[1] = 0.0f;
					IdentityVector[2] = 0.0f; //FIXME: 1.0f for normal!
					break;
				}
				case 4:
				{
					IdentityVector[0] = 0.0f;
					IdentityVector[1] = 0.0f;
					IdentityVector[2] = 0.0f;
					IdentityVector[3] = 1.0f;
					break;
				}
				case 9:
				{
					IdentityVector[0] = 1.0f;
					IdentityVector[1] = 0.0f;
					IdentityVector[2] = 0.0f;
					IdentityVector[3] = 0.0f;
					IdentityVector[4] = 1.0f;
					IdentityVector[5] = 0.0f;
					IdentityVector[6] = 0.0f;
					IdentityVector[7] = 0.0f;
					IdentityVector[8] = 1.0f;
					break;
				}
				default:
				{
					for (int i = 0; i < ControlDimension; i++)
					{
						IdentityVector[i] = 0.0f;
					}
					break;
				}
			}
			if (NumberOfFrames == -1)
			{
				granny_int32x KnotCount = (*GrannyCurveGetKnotCount)(&GrCurve2);
				granny_real32 *ResultKnots = new granny_real32[KnotCount];
				granny_real32 *ResultControls = new granny_real32[KnotCount*ControlDimension];
				(*GrannyCurveExtractKnotValues)(&GrCurve2, 0, KnotCount, ResultKnots, ResultControls, IdentityVector);
				for (int i = 0; i < KnotCount; i++)
				{
					Indent(f);
					fprintf(f, "curve knot: %f\n", ResultKnots[i]);
					Indent(f);
					fprintf(f, "curve control: [");
					for (int j = 0; j < ControlDimension; j++)
					{
						if (j != 0)
						{
							fprintf(f, ",");
						}
						fprintf(f, "%f", ResultControls[i*ControlDimension+j]);
					}
					fprintf(f, "]\n");
				}
				delete[] ResultControls;
				delete[] ResultKnots;
			}
			else
			{
				//Change the number of frames in the animation
				granny_real32 *Result = new granny_real32[ControlDimension];
				for (int i = 0; i < NumberOfFrames; i++)
				{
					granny_real32 time_index = AnimationDuration * (granny_real32(i) / granny_real32(NumberOfFrames));
					(*GrannyEvaluateCurveAtT)(ControlDimension, false,
						false,
						&GrCurve2,
						false,
						AnimationDuration,
						time_index,
						Result,
						IdentityVector);
					Indent(f);
					fprintf(f, "curve knot: %f\n", time_index);
					Indent(f);
					fprintf(f, "curve control: [");
					for (int j = 0; j < ControlDimension; j++)
					{
						if (j != 0)
						{
							fprintf(f, ",");
						}
						fprintf(f, "%f", Result[j]);
					}
					fprintf(f, "]\n");
				}
				delete[] Result;
			}
			delete[] IdentityVector;
		}
		else
		{
			Indent(f);
			fprintf(f, "curve knot: 0\n");
			Indent(f);
			fprintf(f, "curve control: [0.0]\n");
		}
	}

	void OutputTransformTracks(FILE* f, t_TransformTracks TransformTrack)
	{
		Indent(f);
		fprintf(f, "transformtrack (\n");
		Indentation += 2;
		Indent(f);
		fprintf(f, "transformtrack name: %s\n", TransformTrack.Name);
		Indent(f);
		fprintf(f, "transformtrack flags: %d\n", TransformTrack.Flags);

		Indent(f);
		fprintf(f, "orientationcurve (\n");
		Indentation += 2;
		OutputCurve(f, TransformTrack.OrientationCurve);
		Indentation -= 2;
		Indent(f);
		fprintf(f, ")\n");

		Indent(f);
		fprintf(f, "positioncurve (\n");
		Indentation += 2;
		OutputCurve(f, TransformTrack.PositionCurve);
		Indentation -= 2;
		Indent(f);
		fprintf(f, ")\n");

		Indent(f);
		fprintf(f, "scaleshearcurve (\n");
		Indentation += 2;
		OutputCurve(f, TransformTrack.ScaleShearCurve);
		Indentation -= 2;
		Indent(f);
		fprintf(f, ")\n");

		Indentation -= 2;
		Indent(f);
		fprintf(f, ")\n");
	}

#ifdef OutputTrackGroupData
	void OutputTrackGroup(FILE* f, t_TrackGroups* TrackGroup)
	{
		Indent(f);
		fprintf(f, "trackgroup (\n");
		Indentation += 2;
		Indent(f);
		fprintf(f, "trackgroup name: %s\n", TrackGroup->Name);
		//FIXME: MISSING STUFF HERE!
		for (int i = 0; i < TrackGroup->TransformTracks_count; i++)
		{
			OutputTransformTracks(f, TrackGroup->TransformTracks[i]);
		}
		//FIXME: MISSING STUFF HERE!
		Indent(f);
		fprintf(f, "trackgroup initial placement dimensions: %d\n", TrackGroup->InitialPlacement.Dimensions);
		Indent(f);
		fprintf(f, "trackgroup initial placement origin: [%f,%f,%f]\n",
			TrackGroup->InitialPlacement.Origin.Point[0],
			TrackGroup->InitialPlacement.Origin.Point[1],
			TrackGroup->InitialPlacement.Origin.Point[2]);
		Indent(f);
		fprintf(f, "trackgroup initial placement rotation: [%f,%f,%f,%f]\n",
			TrackGroup->InitialPlacement.Rotation.Point[0],
			TrackGroup->InitialPlacement.Rotation.Point[1],
			TrackGroup->InitialPlacement.Rotation.Point[2],
			TrackGroup->InitialPlacement.Rotation.Point[3]);
		Indent(f);
		fprintf(f, "trackgroup initial placement scale: [%f,%f,%f,%f,%f,%f,%f,%f,%f]\n",
			TrackGroup->InitialPlacement.Scale[0],
			TrackGroup->InitialPlacement.Scale[1],
			TrackGroup->InitialPlacement.Scale[2],
			TrackGroup->InitialPlacement.Scale[3],
			TrackGroup->InitialPlacement.Scale[4],
			TrackGroup->InitialPlacement.Scale[5],
			TrackGroup->InitialPlacement.Scale[6],
			TrackGroup->InitialPlacement.Scale[7],
			TrackGroup->InitialPlacement.Scale[8]);
		//FIXME: MISSING STUFF HERE!
		OutputExtendedData(f, TrackGroup->ExtendedData);
		Indentation -= 2;
		Indent(f);
		fprintf(f, ")\n\n");
	}
#endif

#ifdef OutputAnimationData
	void OutputAnimation(FILE* f, t_Animations* Animation)
		{
			Indent(f);
			fprintf(f, "animation (\n");
			Indentation += 2;
			Indent(f);
			fprintf(f, "animation name: %s\n", Animation->Name);
			if (NumberOfFrames == -1)
			{
				Indent(f);
				fprintf(f, "animation duration: %f\n", Animation->Duration);
				Indent(f);
				fprintf(f, "animation timestep: %f\n", Animation->TimeStep);
			}
			else
			{
				Indent(f);
				fprintf(f, "animation duration: %f\n", AnimationDuration);
				Indent(f);
				fprintf(f, "animation timestep: %f\n", AnimationDuration/granny_real32(NumberOfFrames));
			}
			Indent(f);
			fprintf(f, "animation oversampling: %f\n", Animation->Oversampling);

			#ifdef OutputTrackGroupData
			for (int i = 0; i < Animation->TrackGroups_count; i++)
			{
				int j = FindIndexInList(TMPModelInfo->TrackGroups_count, reinterpret_cast<int**>(Animation->TrackGroups), reinterpret_cast<int*>(Animation->TrackGroups[i]));
				Indent(f);
				fprintf(f, "trackgroup: %d\n", j);
			}
			#endif
			Indentation -= 2;
			Indent(f);
			fprintf(f, ")\n");
		}
#endif


// Main function call for importing a .gr2 static base model file.
void OutputModel(FILE* f, t_Models* Model)
	{
		Indent(f);
		fprintf(f, "model (\n");
		Indentation += 2;
		Indent(f);
		fprintf(f, "model name: %s\n", Model->Name);
		Indent(f);
		fprintf(f, "model initial placement dimensions: %d\n", Model->InitialPlacement.Dimensions);
		Indent(f);
		fprintf(f, "model initial placement origin: [%f,%f,%f]\n",
			Model->InitialPlacement.Origin.Point[0],
			Model->InitialPlacement.Origin.Point[1],
			Model->InitialPlacement.Origin.Point[2]);
		Indent(f);
		fprintf(f, "model initial placement rotation: [%f,%f,%f,%f]\n",
			Model->InitialPlacement.Rotation.Point[0],
			Model->InitialPlacement.Rotation.Point[1],
			Model->InitialPlacement.Rotation.Point[2],
			Model->InitialPlacement.Rotation.Point[3]);
		Indent(f);
		fprintf(f, "model initial placement scale: [%f,%f,%f,%f,%f,%f,%f,%f,%f]\n",
			Model->InitialPlacement.Scale[0],
			Model->InitialPlacement.Scale[1],
			Model->InitialPlacement.Scale[2],
			Model->InitialPlacement.Scale[3],
			Model->InitialPlacement.Scale[4],
			Model->InitialPlacement.Scale[5],
			Model->InitialPlacement.Scale[6],
			Model->InitialPlacement.Scale[7],
			Model->InitialPlacement.Scale[8]);

		#ifdef OutputMeshData
			for (int i = 0; i < Model->MeshBindings_count ; i++)
			{
				int j = FindIndexInList(TMPModelInfo->Meshes_count, reinterpret_cast<int**>(TMPModelInfo->Meshes), reinterpret_cast<int*>(Model->MeshBindings[i].Mesh));
				Indent(f);
				fprintf(f, "meshbinding: %d\n", j);
			}
		#endif

		#ifdef OutputSkeletonData
			int j = FindIndexInList(TMPModelInfo->Skeletons_count, reinterpret_cast<int**>(TMPModelInfo->Skeletons), reinterpret_cast<int*>(Model->Skeleton));
			Indent(f);
			fprintf(f, "skeletonbinding: %d\n", j);
		#endif

		Indentation -= 2;
		Indent(f);
		fprintf(f, ")\n\n");
	}


int main(int argc, char** argv)
	{
		printf("grnreader.exe (Modified for QuArK) - version 1.2\n\n");
		if ((argc < 2) || (argc > 3))
		{
			printf("Usage: %s <filename> [<NumberOfFrames>]\n", argv[0]);
			exit(-1);
		}
		if (argc > 2)
		{
			NumberOfFrames = atoi(argv[2]);
		}

		LoadStuff();

		printf("Version granny2.dll: %s\n", ((*GrannyGetVersionString)()));

		(*GrannySetLogCallback)(&logger);

		char* file = argv[1];
		//(*GrannyConvertFileToRaw)(file, "C:\\test.txt");
		GrannyFile* modelfile = (*GrannyReadEntireFile)(file);
		if (! modelfile)
		{
			printf("Couldn't read GR2 file '%s' - maybe it's not the right name, or not in the right folder, or an invalid GR2 file.\n", file);
			UnloadStuff();
			exit(-2);
		}
		t_FileInfo* modelinfo = (*GrannyGetFileInfo)(modelfile);
		if (! modelinfo)
		{
			printf("Couldn't get GR2 FileInfo. I have no idea why.\n");
			UnloadStuff();
			exit(-3);
		}
		TMPModelInfo = modelinfo;

		//FIXME: Call if needed: GrannyTransformFile

		//If needed for the NumberOfFrames-override, find the longest animation duration
		if (NumberOfFrames != -1)
		{
			AnimationDuration = 0.0;
			for (int i = 0; i < modelinfo->Animations_count; i++)
			{
				granny_real32 ThisAnimationDuration = modelinfo->Animations[i]->Duration;
				if (ThisAnimationDuration > AnimationDuration)
				{
					AnimationDuration = ThisAnimationDuration;
				}
			}
		}

		//Opening also cleans output file
		FILE* f = fopen("output.tmp", "w");

		#ifdef OutputArtToolData
			if (modelinfo->ArtToolInfo)
				{
					printf("Outputting art tool info...\n");
					Indent(f);
					fprintf(f, "art tool (\n");
					Indentation += 2;
					Indent(f);
					fprintf(f, "art tool name: %s\n", modelinfo->ArtToolInfo->FromArtToolName);
					Indent(f);
					fprintf(f, "art tool revision: [%d, %d]\n", modelinfo->ArtToolInfo->ArtToolMajorRevision, modelinfo->ArtToolInfo->ArtToolMinorRevision);
					Indent(f);
					fprintf(f, "art tool units per meter: %f\n", modelinfo->ArtToolInfo->UnitsPerMeter);
					Indent(f);
					fprintf(f, "art tool origin: [%f,%f,%f]\n",
						modelinfo->ArtToolInfo->Origin[0],
						modelinfo->ArtToolInfo->Origin[1],
						modelinfo->ArtToolInfo->Origin[2]);
					Indent(f);
					fprintf(f, "art tool right vector: [%f,%f,%f]\n",
						modelinfo->ArtToolInfo->RightVector[0],
						modelinfo->ArtToolInfo->RightVector[1],
						modelinfo->ArtToolInfo->RightVector[2]);
					Indent(f);
					fprintf(f, "art tool up vector: [%f,%f,%f]\n",
						modelinfo->ArtToolInfo->UpVector[0],
						modelinfo->ArtToolInfo->UpVector[1],
						modelinfo->ArtToolInfo->UpVector[2]);
					Indent(f);
					fprintf(f, "art tool back vector: [%f,%f,%f]\n",
						modelinfo->ArtToolInfo->BackVector[0],
						modelinfo->ArtToolInfo->BackVector[1],
						modelinfo->ArtToolInfo->BackVector[2]);
					Indentation -= 2;
					Indent(f);
					fprintf(f, ")\n\n");
				}
		#endif
		#ifdef OutputExporterData
			if (modelinfo->ExporterInfo)
				{
					printf("Outputting exporter info...\n");
					Indent(f);
					fprintf(f, "exporter tool (\n");
					Indentation += 2;
					Indent(f);
					fprintf(f, "exporter name: %s\n", modelinfo->ExporterInfo->ExporterName);
					Indent(f);
					fprintf(f, "exporter revision: [%d, %d]\n", modelinfo->ExporterInfo->ExporterMajorRevision, modelinfo->ExporterInfo->ExporterMinorRevision);
					Indent(f);
					fprintf(f, "exporter customization: %d\n", modelinfo->ExporterInfo->ExporterCustomization);
					Indent(f);
					fprintf(f, "exporter build number: %d\n", modelinfo->ExporterInfo->ExporterBuildNumber);
					Indentation -= 2;
					Indent(f);
					fprintf(f, ")\n\n");
				}
		#endif

		/*#ifdef OutputTextureData
			printf("Outputting textures...\n");
			for (int i = 0; i < modelinfo->Textures_count; i++)
			{
				OutputTexture(f, modelinfo->Textures[i]);
			}
		#endif*/

		#ifdef OutputMaterialData
			printf("Outputting materials...\n");
			for (int i = 0; i < modelinfo->Materials_count; i++)
			{
				OutputMaterial(f, modelinfo->Materials[i]);
			}
		#endif

		#ifdef OutputSkeletonData
			printf("Outputting skeletons...\n");
			for (int i = 0; i < modelinfo->Skeletons_count; i++)
			{
				OutputSkeleton(f, modelinfo->Skeletons[i]);
			}
		#endif

		#ifdef OutputMeshData
			printf("Outputting meshes...\n");
			for (int i = 0; i < modelinfo->Meshes_count; i++)
			{
				OutputMesh(f, modelinfo->Meshes[i]);
			}
		#endif

		#ifdef OutputMeshData
			printf("Outputting tritopologies...\n");
			for (int i = 0; i < modelinfo->TriTopologies_count; i++)
			{
				OutputTriTopology(f, modelinfo->TriTopologies[i]);
			}
		#endif

		#ifdef OutputModelData
			printf("Outputting models...\n");
		   // Lines below outputs multiple sets of bones.
			for (int i = 0; i < modelinfo->Models_count; i++)
			{
				OutputModel(f, modelinfo->Models[i]);
			}
			// Line below outputs only 1st set of bones but causes crash on animation output.
		//	OutputModel(f, modelinfo, modelinfo->Models[0]);
		#endif

		#ifdef OutputTrackGroupData
			printf("Outputting trackgroups...\n");
			for (int i = 0; i < modelinfo->TrackGroups_count; i++)
			{
				OutputTrackGroup(f, modelinfo->TrackGroups[i]);
			}
		#endif

		#ifdef OutputAnimationData
			printf("Outputting animations...\n");
			for (int i = 0; i < modelinfo->Animations_count; i++)
			{
				OutputAnimation(f, modelinfo->Animations[i]);
			}
		#endif
		
		fclose(f);

		if (rename("output.tmp", "output.ms"))
		{
			printf("Unable to rename output. Filename: output.tmp.\n");
		}
		else
		{
			printf("Created output.ms.\n");
		}

		TMPModelInfo = NULL;

		UnloadStuff();

		return 0;	
	}
